%% DATI NUMERICI %% 


Text = 223.15;            %temperatura esterna di corciera a Mach5 in Kelvin Z25000m
x = 1:0.1:10;

Mach = x.';

Thrust_ramjet = 10;       %Ramjet thrust [kN]



M_vehicle_dry_noengine_MR5 = 0;
M_engineATR_dry_MR5 = 4000;           %ATR one engine kg
M_engineDMR_dry_MR5 = 1400;           %DMR one engine kg
M_engine_dry_MR5 = 4000+1400;         %ATR+DMR one engine kg







                   
n=5;                      %number of sub-contractors in the project
n_stage = 1;              %number of stages for the vehicle

f0= 1.04^n_stage;         %Systems engineering / integration factor(Development)           
f1= 0.3;                  %Development standard factor (from 0.3 for a variation of an existing project; to 1.4 for a new concept involving new techniques and technologies)
f2= Mach.^0.15;            %Technical quality factor
f3= 1.4;                  %Team experience factor(from 0.5 for extended experience; to 1.4 for new team with no experience)
f4= 0;                    %Learning curve factor
f6= 1;                    %Deviation from optimal schedule  (1 for on-time and up to 1.6 for heavy delays)
f7= n^0.2;                %Program organization factor
f8= 0.86;                 %Impact of region productivity (1 for USA, 0.86 for Europe, 1.2 for China, 1.5 to 2.1 for Russia)
f9= 0;                    %Impact of subcontractors
f10= 0;
f11= 0;                   %Reduction factor due to absence of government contracts
f0_new= 0;
f10_new= 0;               %Cost reduction factor
f11_new= 0;             

vel_sound= (1.4*287*Text)^0.5;                       %m/s

velocity_cruise= vel_sound.*Mach;                     %m/s
velocity_cruise_KMH = velocity_cruise*3.6;           %km/h




M_vehicle_dry_noengine = 1:20:200000;         % dry mass of vehicle without engines kg

Moew = 130000;                      %kg


M_engineATR_dry = 4000;           %ATR one engine kg
M_engineDMR_dry = 1400;           %DMR one engine kg
M_engine_dry = 4000+1400;         %1ATR+1DMR one engine kg

C_complex= 1;
Ktj= 0.25;                             %low-speed configuration coefficients ranging from 0 to 1
Krj= 0.75;                             %high-speed configuration coefficients ranging from 0 to 1

K_TRL = 0.5 ;                          %factor accounting for the vehicle maturity (from 0 for an average TRL 1 to 1 for an average TRL of 9)

CPI_2023 = 240.01;                          %Consumer Price Index 2023
CPI_2016 = 240.01;                          %Consumer Price Index reference (2016)

MYr_to_Milion_factor = 0.3102;

%% RDTE RESEARCH V2 %MYr %System Level

%Transcost

%RDTE cost for high speed advanced aircraft [WYr]
for M_vehicle_dry_noengine=1:10000
    for Mach=1:91
        Hva_research(M_vehicle_dry_noengine,Mach)=(1746*(M_vehicle_dry_noengine.^0.284)*f1*f3).*(Mach.^0.15);     %airframe (with subsystems), or vehicle without engines
    end 
end


%RDTE cost for turbojet engine [WYr]

Het_research=(1380*(M_engineATR_dry^0.295)+1.12*velocity_cruise)*f1*f3;

%RDTE cost for ramjet engine [WYr]

Her_research=355*(M_engineDMR_dry^0.295)*f1*f3;

%RDTE cost for Combined Cycle Engine [WYr]

Hcce_research=C_complex*(Ktj*Het_research+Krj*Her_research)*f1*f3;

%Total RDTE cost [WYr]_[M$]

%Cost_TOT_RDTE = ((1-K_TRL)*(f0^n_stage)*(Hva_research + Het_research + Her_research + Hcce_research)*f6*f7*f8)*MYr_to_Milion_factor*(CPI_2023/CPI_2016);



Hva_research_MR5=1746*(M_vehicle_dry_noengine_MR5.^0.284)*f1*f2*f3;
Het_research_MR5=(1380*(M_engineATR_dry_MR5^0.295)+1.12*velocity_cruise)*f1*f3;
Her_research_MR5=355*(M_engineDMR_dry_MR5^0.295)*f1*f3;
Hcce_research_MR5=C_complex*(Ktj*Het_research_MR5+Krj*Her_research_MR5)*f1*f3;

Cost_TOT_RDTE_MR5 = ((1-K_TRL)*(f0^n_stage)*(Hva_research_MR5 + Het_research_MR5 + Her_research_MR5 + Hcce_research_MR5)*f6*f7*f8)*MYr_to_Milion_factor*(CPI_2023/CPI_2016);


%PLOT

plot(M_vehicle_dry_noengine,Hva_research)





%{
surf(Hva_research)
colormap hsv
colorbar 
%}
%Roskam
%Cost_RDTE = Caed_rdte + Cdst_rdte + Cfta_rdte + Cfto_rdte + Ctsf_rdte + Cpro_rdte + Cfin_rdte; 


%% RDTE RESEARCH V2 %MYr %Sub-System Level

mpunto_bo_LH2 = 1;              %Boil-off flow rate [kg/s]
P = 10000;                      %Power produced by TEMS [W]
q = 10000;                      %Heat flux [W/m^2]
n_engine_types = 2;             %Number of engine types installed
rho_LH2 = 10000;                %fuel density [kg/m3]


%RDTE cost for fuel system [WYr]

S_fuel_research = ((0.1*(Moew^0.68))+(0.5*(rho_LH2^(-0.6)))+(0.49*(M_engine_dry^0.51)))*f1*f3;

%RDTE cost for TPS [WYr]

S_TPS_research = ((0.56*(Moew^0.59))+(1.8*(q^0.51)))*f1*f3;

%RDTE cost for TEMS [WYr]

S_TEMS_research = ((5.73*(Moew^0.26))+(0.8*(P^0.17))+(0.53*(mpunto_bo_LH2^0.19)))*f1*f3;



%% PROD V2 %MYr %System Level

n_engine_installed = 7;
n_MR5produced = 1;
Q = 100000;                 %Heat load [J/m2]    


%Production cost for high speed advanced aircraft [WYr]



%Production cost for turbojet engine [WYr]



%Production cost for ramjet engine [WYr]



%Production cost for Combined Cycle Engine [WYr]




%Total Production cost [WYr]_[M$]






%% OPS DOC
















%% OPS IOC



















%% DISP











%% TOT



